/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;

public class BlockPlantWall
extends BlockBaseNotFull
implements BehaviourPlant {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)BlockPlantWall.m_49796_((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)BlockPlantWall.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0), (Object)Direction.WEST, (Object)BlockPlantWall.m_49796_((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)BlockPlantWall.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0)));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public BlockPlantWall(MapColor color) {
        super(Materials.makeNetherGrass(color).m_222979_(BlockBehaviour.OffsetType.NONE));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    @Environment(value=EnvType.CLIENT)
    public float m_7749_(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos targetPos = pos.m_121945_(direction.m_122424_());
        BlockState targetState = level.m_8055_(targetPos);
        return targetState.m_60783_((BlockGetter)level, targetPos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (this.m_7898_(state, (LevelReader)world, pos)) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction[] directions = ctx.m_6232_();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

